-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
	  self.initialized = true
	  
	  if not self.loaded then
		  self.caSTactive = false
		  self.caLTactive = false
	  end
	
	  self.coAttST:LinkToTarget("coAttST")
	  self.coAttLT:LinkToTarget("coAttLT")
  end
  
  if self.caSTactive then
	  self.coAttST:TriggerAllTargets()
    self.caSTactive = false
  end
  
  if self.caLTactive then
	  self.coAttLT:TriggerAllTargets()
    self.caLTactive = false
  end
  
end

function OnTrigger(self, source, target)
  Debug:Log("Source = " .. source .. " !!! Target = " .. target)
  if target == "cAttST" then
	  self.caSTactive = true
  elseif target == "cAttLT" then
	  self.caLTactive = true
  elseif target == "deactcAttST" then
	  self.caSTactive = false
  elseif target == "deactcAttLT" then
	  self.caLTactive = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.caSTactive = ar:Read()
		self.caLTactive = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.caSTactive)
    ar:Write(self.caLTactive)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("cAttST")
  self:AddTriggerTarget("cAttLT")
  self:AddTriggerTarget("deactcAttST")
  self:AddTriggerTarget("deactcAttLT")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("coAttST")
  self:AddTriggerSource("coAttLT")
end
